/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.magmafoundation.magma.patcher.Patcher;
import org.magmafoundation.magma.patcher.impl.WorldEditPatcher;

public class PatcherManager {
    private final List<Patcher> patcherList = new ArrayList<Patcher>();
    public static final Logger LOGGER = LogManager.getLogger();

    public void init() {
        this.initPatches();
        this.patcherList.forEach(patcher -> LOGGER.info("{} [{}] loaded", (Object)patcher.getName(), (Object)patcher.getDescription()));
        LOGGER.info("{} patches loaded!", (Object)this.patcherList.size());
    }

    private void initPatches() {
        this.patcherList.add(new WorldEditPatcher());
    }

    public List<Patcher> getPatcherList() {
        return this.patcherList;
    }

    public <T extends Patcher> Patcher getPatchByClass(Class<T> clazz) {
        return this.patcherList.stream().filter(patcher -> patcher.getClass().equals(clazz)).findFirst().map(clazz::cast).orElse(null);
    }

    public Patcher getPatchByName(String patchName) {
        return this.patcherList.stream().filter(patcher -> patcher.getName().toLowerCase().replaceAll(" ", "").equalsIgnoreCase(patchName)).findFirst().orElse(null);
    }
}

